module Ordering where
open import Equality
open import Nat
open import Logic



infix 5 _≤_

data _≤_ : ℕ -> ℕ -> Set where
  z≤n : ∀ (n : ℕ) -> zero ≤ n
  s≤s : ∀ (n m : ℕ) -> n ≤ m -> succ n ≤ succ m

theorem-refl≤ : ∀ (n : ℕ) -> n ≤ n
theorem-refl≤ zero = z≤n zero
theorem-refl≤ (succ n) = s≤s n n (theorem-refl≤ n)

theorem-refl≤' : ∀ (n m : ℕ) -> n == m -> n ≤ m
theorem-refl≤' n m refl = theorem-refl≤ n

theorem-trans : ∀ (n m k : ℕ) -> n ≤ m -> m ≤ k -> n ≤ k
theorem-trans .zero m k (z≤n .m) hyp2 = z≤n k
theorem-trans .(succ n) .(succ m) .(succ m₁) (s≤s n m hyp1) (s≤s .m m₁ hyp2) = s≤s n m₁ (theorem-trans n m m₁ hyp1 hyp2)

anti-symmetric : ∀ (n m : ℕ) -> n ≤ m -> m ≤ n -> n == m
anti-symmetric .0 .0 (z≤n .0) (z≤n .0) = refl
anti-symmetric .(succ n) .(succ m) (s≤s n m hyp1) (s≤s .m .n hyp2) = context succ (anti-symmetric n m hyp1 hyp2)

theorem-≤-succ : ∀ (n m : ℕ) -> n ≤ m -> n ≤ succ m
theorem-≤-succ .0 m (z≤n .m) = z≤n (succ m)
theorem-≤-succ .(succ n) .(succ m) (s≤s n m hyp) = s≤s n (succ m) (theorem-≤-succ n m hyp)

lemma-n≤0 : ∀ n -> n ≤ 0 -> n == 0
lemma-n≤0 0 (z≤n 0) = refl

theorem-≤-invert : ∀ (n m : ℕ) -> n ≤ succ m -> n ≤ m ∨ n == succ m
theorem-≤-invert zero m hyp = left (z≤n m)
theorem-≤-invert (succ n) zero (s≤s .n .0 hyp) = right (context succ (lemma-n≤0 n hyp))
theorem-≤-invert (succ n) (succ m) (s≤s .n .(succ m) hyp) with ih
  where
    ih : n ≤ m ∨ n == succ m
    ih = theorem-≤-invert n m hyp
theorem-≤-invert (succ n) (succ m) (s≤s .n .(succ m) hyp) | left x = left (s≤s n m x)
theorem-≤-invert (succ n) (succ m) (s≤s .n .(succ m) hyp) | right x = right (context succ x)
    

-- ----------------------------------------------------------------------
-- * Monotonicity of addition

lemma-n-plus-succ-m : ∀ m n -> succ (n + m) ≤ n + succ m
lemma-n-plus-succ-m m zero = theorem-refl≤ (succ m)
lemma-n-plus-succ-m m (succ n) = s≤s (succ (n + m)) (n + succ m) (lemma-n-plus-succ-m m n)

lemma-m-leq-n+m : ∀ m n -> m ≤ n + m
lemma-m-leq-n+m zero n = z≤n (n + zero)
lemma-m-leq-n+m (succ m) n = theorem-trans (succ m) (succ (n + m)) (n + succ m)  step1 step2 where
  step1 : succ m ≤ succ (n + m)
  step1 = s≤s m (n + m) (lemma-m-leq-n+m m n)

  step2 : succ (n + m) ≤ n + succ m
  step2 = lemma-n-plus-succ-m m n

theorem-add-monotone-left : ∀ n n' m -> n ≤ n' -> n + m ≤ n' + m
theorem-add-monotone-left .0 n' m (z≤n .n') = lemma-m-leq-n+m m n'
theorem-add-monotone-left .(succ n) .(succ m₁) m (s≤s n m₁ hyp) = s≤s (n + m) (m₁ + m) (theorem-add-monotone-left n m₁ m hyp)

theorem-add-monotone-right : ∀ n m m' -> m ≤ m' -> n + m ≤ n + m'
theorem-add-monotone-right n m m' hyp = theorem-trans (n + m) (m + n) (n + m') step1 (theorem-trans _ _ _ step2 step3)
  where
    step1 : n + m ≤ m + n
    step1 = theorem-refl≤' (n + m) (m + n) (lemma-add-commutative n m)

    step2 : m + n ≤ m' + n
    step2 = theorem-add-monotone-left m m' n hyp

    step3 : m' + n ≤ n + m'
    step3 = theorem-refl≤' (m' + n) (n + m') (lemma-add-commutative m' n)

theorem-add-monotone : ∀ (n n' m m' : ℕ) -> n ≤ n' -> m ≤ m' -> n + m ≤ n' + m'
theorem-add-monotone n n' m m' hyp1 hyp2 = theorem-trans _ _ _ step1 step2
  where
    step1 : n + m ≤ n + m'
    step1 = theorem-add-monotone-right n m m' hyp2

    step2 : n + m' ≤ n' + m'
    step2 = theorem-add-monotone-left n n' m' hyp1


lemma-m-times-zero : ∀ m -> zero == m * zero
lemma-m-times-zero zero = refl
lemma-m-times-zero (succ m) = context (λ x → x + zero) (lemma-m-times-zero m)


theorem-mult-monotone-left : ∀ n n' m -> n ≤ n' -> n * m ≤ n' * m
theorem-mult-monotone-left .0 n' m (z≤n .n') = z≤n (n' * m)
theorem-mult-monotone-left .(succ n) .(succ m₁) m (s≤s n m₁ hyp) = theorem-add-monotone-left (n * m) (m₁ * m) m (theorem-mult-monotone-left n m₁ m hyp)

theorem-mult-monotone-right : ∀ n m m' -> m ≤ m' -> n * m ≤ n * m'
theorem-mult-monotone-right n m m' hyp = theorem-trans (n * m) (m * n) (n * m') step1 (theorem-trans (m * n) (m' * n) (n * m') step2 step3)
  where
    step1 : n * m ≤ m * n
    step1 = theorem-refl≤' (n * m) (m * n) (theorem-mult-commutative n m)

    step2 : m * n ≤ m' * n
    step2 = theorem-mult-monotone-left m m' n hyp

    step3 : m' * n ≤ n * m'
    step3 = theorem-refl≤' (m' * n) (n * m') (theorem-mult-commutative m' n)


theorem-mult-monotone : ∀ (n n' m m' : ℕ) -> n ≤ n' -> m ≤ m' -> n * m ≤ n' * m'
theorem-mult-monotone n n' m m' hyp1 hyp2 = theorem-trans _ _ _ step1 step2
  where
    step1 : n * m ≤ n' * m
    step1 = theorem-mult-monotone-left n n' m hyp1

    step2 : n' * m ≤ n' * m'
    step2 = theorem-mult-monotone-right n' m m' hyp2


-- ----------------------------------------------------------------------
-- * The less-than relation

data _<_ : ℕ -> ℕ -> Set where
  less-zero : ∀ {n} -> zero < succ n
  less-succ : ∀ {n m} -> n < m -> succ n < succ m

infix 5 _<_

lemma-zero-not-less : ¬ (zero < zero)
lemma-zero-not-less = λ ()

lemma-less-irreflexive : ∀ n -> ¬ (n < n)
lemma-less-irreflexive zero ()
lemma-less-irreflexive (succ n) (less-succ hyp) = lemma-less-irreflexive n hyp

lemma-total : ∀ n m -> n == m ∨ (n < m ∨ m < n)
lemma-total zero zero = left refl
lemma-total zero (succ m) = right (left less-zero)
lemma-total (succ n) zero = right (right less-zero)
lemma-total (succ n) (succ m) =
  orElim (\ x -> left (context succ x))
         (\ x -> orElim (λ x₁ → right (left (less-succ x₁))) (λ x₁ → right (right (less-succ x₁))) x)
         (lemma-total n m)

theorem-trans-< : ∀ (n m k : ℕ) -> n < m -> m < k -> n < k
theorem-trans-< .0 .(succ _) .(succ _) less-zero (less-succ h2) = less-zero
theorem-trans-< (succ n) (succ m) (succ k) (less-succ h1) (less-succ h2) = less-succ (theorem-trans-<  n m k h1 h2)

nogap : {a : Set} -> (n m : ℕ) -> n < m -> m < succ n -> a
nogap .0 .(succ _) less-zero (less-succ ())
nogap .(succ _) .(succ _) (less-succ h1) (less-succ h2) = nogap _ _ h1 h2


theorem-≤-to-< : (n m : ℕ) -> n ≤ m -> n < m ∨ n == m
theorem-≤-to-< .0 zero (z≤n .0) = right refl
theorem-≤-to-< .0 (succ m) (z≤n .(succ m)) = left less-zero
theorem-≤-to-< .(succ n) .(succ m) (s≤s n m h1) with theorem-≤-to-< n m h1
... | left x = left (less-succ x)
... | right x = right (context succ x)


theorem-<-to-≤ : (n m : ℕ) -> n < m -> n ≤ m
theorem-<-to-≤ 0 (succ n) less-zero = z≤n (succ n)
theorem-<-to-≤ (succ n) (succ m) (less-succ h) = s≤s n m (theorem-<-to-≤ n m h)
 
lemma-less-succ : (n m : ℕ) -> succ n < succ m -> n < m
lemma-less-succ n m (less-succ h1) = h1
