module EvenOdd where
open import Nat
open import Logic
open import Equality

data Even : ℕ -> Set where
  even-base : Even zero
  even-step : ∀ (n : ℕ) -> Even n -> Even (succ (succ n))


theorem-add-even : ∀ (n m : ℕ) -> Even n -> Even m -> Even (n + m)
theorem-add-even .zero m even-base hyp2 = hyp2
theorem-add-even .(succ (succ n')) m (even-step n' hyp1') hyp2 = even-step (n' + m) (theorem-add-even n' m hyp1' hyp2)


data Odd : ℕ -> Set where
  base-odd : Odd (succ zero)
  step-odd : ∀ (n : ℕ) -> Odd n -> Odd (succ (succ n))


lemma-even-odd : (n : ℕ) -> Even n -> Odd (succ n)
lemma-even-odd .zero even-base = base-odd
lemma-even-odd .(succ (succ n)) (even-step n h) = step-odd (succ n) (lemma-even-odd n h)

lemma-odd-even : (n : ℕ) -> Odd n -> Even (succ n)
lemma-odd-even .(succ zero) base-odd = even-step zero even-base
lemma-odd-even .(succ (succ n)) (step-odd n h) = even-step (succ n) (lemma-odd-even n h)

lemma-even-or-odd : (n : ℕ) -> Even n ∨ Odd n
lemma-even-or-odd zero = left even-base
lemma-even-or-odd (succ n) = orElim (λ x → right (lemma-even-odd n x)) (λ x → left (lemma-odd-even n x)) (lemma-even-or-odd n)

lemma-not-even-and-odd : ∀ (n : ℕ) -> ¬ (Even n ∧ Odd n)
lemma-not-even-and-odd .(succ (succ n)) (even-step n x , step-odd .n y) = lemma-not-even-and-odd n (x , y)


odd-add-odd-even : (n m : ℕ) -> Odd n -> Odd m -> Even (n + m)
odd-add-odd-even .(succ zero) m base-odd h2 = lemma-odd-even m h2
odd-add-odd-even .(succ (succ n)) m (step-odd n h1) h2 = even-step (n + m) (odd-add-odd-even n m h1 h2)

odd-add-even-odd : (n m : ℕ) -> Odd n -> Even m -> Odd (n + m)
odd-add-even-odd .(succ zero) m base-odd h2 = lemma-even-odd m h2
odd-add-even-odd .(succ (succ n)) m (step-odd n h1) h2 = 
  step-odd (n + m) (odd-add-even-odd n m h1 h2)

odd-mult-odd-odd : (n m : ℕ) -> Odd n -> Odd m -> Odd (n * m)
odd-mult-odd-odd .(succ zero) m base-odd h2 = h2
odd-mult-odd-odd .(succ (succ n)) m (step-odd n h1) h2 =
  subst (\ u -> Odd u) (symm (lemma-add-assoc (n * m) m m)) (odd-add-even-odd (n * m) (m + m) (odd-mult-odd-odd n m h1 h2) (odd-add-odd-even m m h2 h2))

double-even : (n : ℕ) -> Even (n + n)
double-even zero = even-base
double-even (succ n) =
  subst (λ u → Even (succ u)) (lemma-add-succ n n) (even-step (n + n) (double-even n))

even-mult : (n m : ℕ) -> Even n -> Even (n * m)
even-mult .zero m even-base = even-base
even-mult .(succ (succ n)) m (even-step n h) =
  subst Even (symm (lemma-add-assoc (n * m) m m)) (theorem-add-even (n * m) (m + m) (even-mult n m h) (double-even m)) 

lemma-square-odd : (n : ℕ) -> Odd n -> Odd (n * n)
lemma-square-odd n h1 = odd-mult-odd-odd n n h1 h1

lemma-square-even : (n : ℕ) -> Even n -> Even (n * n)
lemma-square-even n h = even-mult n n h

