module Bool where

-- ----------------------------------------------------------------------
-- * The booleans

data Bool : Set where
  true : Bool
  false : Bool

-- ----------------------------------------------------------------------
-- ** Some functions

-- Negation
not : Bool -> Bool
not true = false
not false = true

_and_ : Bool -> Bool -> Bool
true and y = y
false and y = false

_or_ : Bool -> Bool -> Bool
true or y = true
false or y = y

_implies_ : Bool -> Bool -> Bool
true implies x = x
false implies x = true

if_then_else_ : {a : Set} -> Bool -> a -> a -> a
if_then_else_ true x y = x
if_then_else_ false x y = y
