/* join.y */
/* This is part of the source for the Core Join Calculus Compiler cjcc */
/* Copyright (C) 1996 Peter Selinger 07/23/96 revised 10/01/96 */
/* This is free software under the terms of the GNU General Public License. */

%{
#include "types.c"
#include "sem.c"
#include "semantics.c"

sem *global_code;
%}
%union {
explisttype nl;
exptype ex;
char *na;
int ic;
int bc;
char *sc;
processtype pr;
parameterlisttype pl;
joinpatterntype jp;
definitiontype df;
receivertype rc;
basicdeftype bd;
}

/* BISON Declarations */

%token <na> NAME
%token DEF
%token IN
%token AND
%token THEN
%token <ic> INTCONST 
%token <sc> STRCONST
%token <bc> BOOLECONST
%token WILDCARD
%type <ex> exp
%type <nl> explist ne_explist
%type <pr> process message 
%type <pl> parameterlist ne_parameterlist
%type <jp> joinpattern 
%type <rc> receiver 
%type <df> definition
%type <bd> basicdef
%expect 2

/* Grammar follows */
%%
/* test: message { semprint($1.local); semprint($1.global); printf("\n"); 
longlistprint($1.free); printf("\n");} */

program:  process	{ global_code=program_from_process($1); }
;

process:  message		
	| '{' process '}'	{ $$ = $2 }
        | '{' '}'		{ $$ = empty_process(); }     
        | process '|' message	{ $$ = proc_from_proc_message($1,$3);}
	| DEF '/' '*' NAME '*' '/' definition IN process
				{$$ = proc_from_name_def_proc($4,$7,$9);}
        | DEF definition IN process	{$$=proc_from_def_proc($2,$4);}
	| '{' error '}'		/* error recovery */
	| DEF error IN process  /* error recovery */
;

message:  NAME '<' explist '>'	{$$ = message_from_name_explist($1,$3);}
	| NAME '<' error '>'	/* error recovery */
;

explist: /* empty */	{ $$ = empty_explist(); }
	| ne_explist
;

ne_explist: exp	{ $$ = explist_from_exp_explist($1,empty_explist()); }
	| exp ',' ne_explist { $$ = explist_from_exp_explist($1,$3); }
;

exp:	  NAME		{ $$ = exp_from_name($1); }
	| INTCONST      { $$ = exp_from_int($1); }
	| STRCONST      { $$ = exp_from_str($1); }
	| BOOLECONST    { $$ = exp_from_boole($1); }
        | WILDCARD      { $$ = exp_from_wildcard(); }
;

definition: basicdef	{ $$=definition_from_basicdef($1); }
	| definition AND basicdef	
			{ $$=definition_from_definition_basicdef($1,$3); }
;

basicdef: joinpattern THEN process
			{ $$=basicdef_from_jp_process($1,$3); }
;

joinpattern: receiver   { $$=joinpattern_from_receiver($1); }
	| joinpattern '|' receiver    
			{ $$=jp_from_jp_receiver($1,$3); }
;

receiver:  NAME '<' parameterlist '>'
			{ $$=receiver_from_name_parameterlist($1,$3); }
	| NAME '<' error '>'	/* error recovery */
;

parameterlist: /* empty */		{ $$=empty_parameterlist(); }
	| ne_parameterlist
;

ne_parameterlist: NAME	{ $$=pl_from_name_pl($1,empty_parameterlist()); }
	| NAME ',' ne_parameterlist	{ $$=pl_from_name_pl($1,$3); }
;

%%

#include "lex.yy.c"
#include "main.c"
