/* lists.c */
/* This is part of the source for the Core Join Calculus Compiler cjcc */
/* Copyright (C) 1996 Peter Selinger */
/* This is free software under the terms of the GNU General Public License. */

typedef struct list {
  sem *x;  /* list element */
  struct list *next;
} list;

list *emptylist(void) {
  return NULL;
}

int isempty(list *l) {
  if (l==NULL)
    return 1;
  return 0;
}

sem *head(list *l) {
  if (l!=NULL)
    return l->x;
  return NULL;
}

list *tail(list *l) {
  if (l!=NULL)
    return l->next;
  return NULL;
}

list *cons(sem *x, list *l) {
  list *p=(list *)calloc(1,sizeof(list));
  if (p!=NULL) {
    p->x=x;
    p->next=l;
  }
  return p;
}

list *append(list *l, list *m) {
  if (l==NULL)
    return m;
  if (l->next==NULL) {
    l->next=m;
    return l;
  }
  append(l->next,m);
  return l;
}

int member(sem *x, list *l) {
  if (l==NULL)
    return 0;
  if (semeq(x,l->x))
    return 1;
  return member(x,l->next);
}

list *setify(list *l) {
  if (l==NULL)
    return NULL;
  if (member(l->x,l->next))
    return setify(l->next);
  l->next=setify(l->next);
  return l;
}

void listprint(FILE *file,list *l) {
  if (l==NULL)
    return;
  semprint(file,l->x);
  listprint(file,l->next);
}

void longlistprint(FILE *file, list *l) {
  fprintf(file,"[");
  while (l!=NULL) {
    longsemprint(file,l->x);
    l=l->next;
  }
  fprintf(file,"]");
}

int listeq(list *l, list *m) {
  if (l==NULL && m==NULL)
    return 1;
  if (l!=NULL && m!=NULL)
    return (semeq(l->x,m->x) && listeq(l->next,m->next));
  return 0;
}

int disjoint(list *l, list *m) {
  while (l!=NULL) {
    if (member(l->x,m))
      return 0;
    l=l->next;
  }
  return 1;
}

list *singleton(sem *s) {
  return cons(s, NULL);
}

list *doubleton(sem *s, sem *t) {
  return cons(s, cons(t, NULL));
}

list *listclone(list *l) {
  if (l==NULL)
    return NULL;
  return cons(l->x,listclone(l->next));
}

list *minus(list *l, list *m) {
  if (l==NULL)
    return NULL;
  if (member(l->x,m))
    return minus(l->next,m);
  return cons(l->x,minus(l->next,m));
}

int length(list *l) {
  if (l==NULL)
    return 0;
  return 1+length(l->next);
}

sem *listelement(list *l, int i) {
  if (l==NULL)
    return NULL;
  if (i<=0)
    return (l->x);
  else
    return listelement(l->next, i-1);
}
