/* serverdef.sc: A string constant included by semantics.c */
/* This is part of the source for the Core Join Calculus Compiler cjcc */
/* Copyright (C) 1996 Peter Selinger */
/* This is free software under the terms of the GNU General Public License. */

/*  ----------------------serverdef.c-------------------------------- */

"void printvalue(FILE *file, value v)\n"
"{\n"
"  switch (v.type) {\n"
"  case INT:\n"
"    fprintf(file, \"\%d\", v.c.i);\n"
"    break;\n"
"  case STR:\n"
"    fprintf(file, \"\%s\", v.c.s);\n"
"    break;\n"
"  case BOOLE:\n"
"    fprintf(file, \"\%s\", v.c.b ? \"true\" : \"false\");\n"
"    break;\n"
"  case CHANNEL:\n"
"    fprintf(file, \n"
"	    \"[channel \%d (arity \%d) of incarnation \%d of definition \%d]\", \n"
"	    v.c.chan.entry, v.c.chan.inc->arity[v.c.chan.entry], \n"
"	    v.c.chan.inc, v.c.chan.inc->code);\n"
"    break;\n"
"  case WILDCARD:\n"
"    fprintf(file, \"*\");\n"
"    break;\n"
"  }\n"
"}\n"
"\n"
"#define SACCSIZE 255\n"
"\n"
"int readint(FILE *file, value *out_val)\n"
"{\n"
"  int i,stat;\n"
"  static char sacc[SACCSIZE];  /* string accumulator */\n"
"  \n"
"  stat=fscanf(file, \"\%s\", sacc);\n"
"  if (stat==EOF)\n"
"    return EOF;\n"
"  if (stat==0)\n"
"    return 1;\n"
"  *out_val=inint(atoi(sacc));\n"
"  return 0;\n"
"}\n"
"\n"
"/* Definition of the global server */\n"
"\n"
"void server(incarnation *inc, int entry) \n"
"{\n"
"  switch (entry) {\n"
"  case 0:      /* entry 0 is the 'write' server: write<printee,cont,exc> */\n"
"    if (queue_length(inc->q+entry) >= 3) {\n"
"      value printee,cont,exc;\n"
"\n"
"      pop(&printee,inc->q+entry);\n"
"      pop(&cont,inc->q+entry);\n"
"      pop(&exc,inc->q+entry);\n"
"      printvalue(stdout,printee);\n"
"      sendalong0(cont);\n"
"    }\n"
"    break;\n"
"  case 1:      /* entry 1 is the 'readint' server: readint<cont,exc> */\n"
"    if (queue_length(inc->q+entry) >= 2) {\n"
"      value cont,exc;\n"
"      value result;\n"
"      int stat;\n"
"      pop(&cont,inc->q+entry);\n"
"      pop(&exc,inc->q+entry);\n"
"      stat=readint(stdin, &result);\n"
"      if (stat==EOF)\n"
"	sendalong1(exc,instr(\"End of file\"));\n"
"      else if (stat)\n"
"	sendalong1(exc,instr(\"Bad input\"));\n"
"      else \n"
"	sendalong1(cont,result);\n"
"    }\n"
"    break;\n"
"                  /* Arithmetic operations */\n"
"  case 2:          /* entry 2 is test for equality */\n"
"  case 3:          /* entry 3 is 'plus': plus<first,second,cont,exc> */\n"
"  case 4:          /* entry 4 is 'minus' */\n"
"  case 5:          /* entry 5 is 'times' */\n"
"  case 6:          /* entry 6 is 'div' */\n"
"  case 7:          /* entry 7 is 'less' */\n"
"    if (queue_length(inc->q+entry) >= 4) {\n"
"      value first, second, cont, exc;\n"
"      pop(&first,inc->q+entry);\n"
"      pop(&second,inc->q+entry);\n"
"      pop(&cont,inc->q+entry);\n"
"      pop(&exc,inc->q+entry);\n"
"      if (first.type != INT || second.type !=INT) {\n"
"	if (entry==2)\n"
"	  sendalong1(exc,instr(\"Cannot test non-integers for equality\"));\n"
"	else if (entry==7)\n"
"	  sendalong1(exc,instr(\"Cannot test non-integers for inequality\"));\n"
"	else\n"
"	  sendalong1(exc,instr(\"Arithmetic operation on non-integers\"));\n"
"	return;\n"
"      }\n"
"      switch (entry) {\n"
"      case 2: sendalong1(cont,inboole(first.c.i == second.c.i)); break;\n"
"      case 3: sendalong1(cont,inint(first.c.i + second.c.i)); break;\n"
"      case 4: sendalong1(cont,inint(first.c.i - second.c.i)); break;\n"
"      case 5: sendalong1(cont,inint(first.c.i * second.c.i)); break;\n"
"      case 6: \n"
"	if (second.c.i==0)\n"
"	  sendalong1(exc,instr(\"Division by zero\"));\n"
"	else\n"
"	  sendalong1(cont,inint(first.c.i / second.c.i)); \n"
"	break;\n"
"      case 7: sendalong1(cont,inboole(first.c.i < second.c.i)); break;\n"
"      }\n"
"    }\n"
"    break;\n"
"  case 8:  /* entry 8 is if-then-else:  if<cond,thenk,elsek,exc> */\n"
"    if (queue_length(inc->q+entry) >= 4) {\n"
"      value cond, thenk, elsek, exc;\n"
"      pop(&cond,inc->q+entry);\n"
"      pop(&thenk,inc->q+entry);\n"
"      pop(&elsek,inc->q+entry);\n"
"      pop(&exc,inc->q+entry);\n"
"      if (cond.type != BOOLE) \n"
"	sendalong1(exc,instr(\"First argument of 'if' is not a boolean\"));\n"
"      else if (cond.c.b)\n"
"	sendalong0(thenk);\n"
"      else\n"
"	sendalong0(elsek);\n"
"    }\n"
"    break;\n"
"  }\n"
"} \n"
"\n"

