-- This file is part of Quipper. Copyright (C) 2011-2016. Please see the
-- file COPYRIGHT for a list of authors, copyright holders, licensing,
-- and other details. All rights reserved.
-- 
-- ======================================================================

-- | This library provides functions for optimizing classical
-- circuits. It is intended to reduce the size of
-- automatically-generated circuits, such as those that are built
-- using Quipper's @build_circuit@ keyword.
-- 
-- Note: the resulting circuit is not expected to be optimal in
-- absolute terms. In general, finding the smallest possible circuit
-- to represent a given boolean function is an NP-hard
-- problem. Rather, we transform the input circuit by applying a
-- number of heuristics and an algebraic optimization technique. This
-- results in the removal of redundant qubits and gates that are
-- typical for machine-generated circuits. It generally decreases the
-- number of gates and ancillas.
-- 
-- For example, consider the circuit for a simple adder, as generated
-- by the @build_circuit@ mechanism:
-- 
-- \[image adder-unoptimized.png]
-- 
-- The optimized version, as generated by 'simplify_classical', looks
-- like this:
-- 
-- \[image adder-optimized.png]
-- 
-- The above example can be found in the file @tests/OptimTest.hs@.

module QuipperLib.ClassicalOptim (
  simplify_classical,
  classical_to_reversible_optim,
  box_classical_to_reversible_optim
) where

import QuipperLib.ClassicalOptim.QuipperInterface

